﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace NonInteropDynamic
{
    class Static
    {
        // Listing 18-21. Prosty filtr
        static bool Test(int x)
        {
            return x < 100;
        }

        public static void Test()
        {
            // Listing 18-22. Filtrowanie za pomocą LINQ
            var nums = Enumerable.Range(1, 200);
            var filteredNumbers = nums.Where(Test);
        }
    }

    class Dynamic
    {
        // Listing 18-23. Filtr dynamiczny
        static bool Test(dynamic x)
        {
            return x < 100;
        }

        // Listing 18-25. Implementacja metody Where dostosowana do wymagań typu dynamicznego
        static IEnumerable<T> DynamicWhere<T>(IEnumerable<T> input, dynamic test)
        {
            foreach (T item in input)
            {
                if (test(item))
                {
                    yield return item;
                }
            }
        }

        public static void Test()
        {
            var nums = Enumerable.Range(1, 200);

            {
                // Listing 18-24. Dostosowanie dynamicznego filtra do wymagań LINQ
                var filteredNumbers = nums.Where(x => Test(x));
            }


            // Zmień tę wartość na true, aby przekonać się, że Listing 18-26 się nie kompiluje.
#if false
            {
                // Listing 18-26. Nieudana próba wywołania metody DynamicWhere
                var filteredNumbers = DynamicWhere(nums, Test); // Błąd kompilatora
            }
#else
            {
                // Listing 18-27. Podpowiedź dla metody DynamicWhere
                var filteredNumbers = DynamicWhere(nums, (Predicate<dynamic>) Test);
            }
#endif
        }
    }

    class Program
    {

        static void Main(string[] args)
        {
            Static.Test();
            Dynamic.Test();
        }
    }
}
